USE [master]
GO

/****** Object:  Database [api]    Script Date: 03/24/2014 19:02:38 ******/
CREATE DATABASE [api]

ALTER DATABASE [api] SET COMPATIBILITY_LEVEL = 100
GO

IF (1 = FULLTEXTSERVICEPROPERTY('IsFullTextInstalled'))
begin
EXEC [api].[dbo].[sp_fulltext_database] @action = 'enable'
end
GO

ALTER DATABASE [api] SET ANSI_NULL_DEFAULT OFF 
GO

ALTER DATABASE [api] SET ANSI_NULLS OFF 
GO

ALTER DATABASE [api] SET ANSI_PADDING OFF 
GO

ALTER DATABASE [api] SET ANSI_WARNINGS OFF 
GO

ALTER DATABASE [api] SET ARITHABORT OFF 
GO

ALTER DATABASE [api] SET AUTO_CLOSE OFF 
GO

ALTER DATABASE [api] SET AUTO_CREATE_STATISTICS ON 
GO

ALTER DATABASE [api] SET AUTO_SHRINK OFF 
GO

ALTER DATABASE [api] SET AUTO_UPDATE_STATISTICS ON 
GO

ALTER DATABASE [api] SET CURSOR_CLOSE_ON_COMMIT OFF 
GO

ALTER DATABASE [api] SET CURSOR_DEFAULT  GLOBAL 
GO

ALTER DATABASE [api] SET CONCAT_NULL_YIELDS_NULL OFF 
GO

ALTER DATABASE [api] SET NUMERIC_ROUNDABORT OFF 
GO

ALTER DATABASE [api] SET QUOTED_IDENTIFIER OFF 
GO

ALTER DATABASE [api] SET RECURSIVE_TRIGGERS OFF 
GO

ALTER DATABASE [api] SET  DISABLE_BROKER 
GO

ALTER DATABASE [api] SET AUTO_UPDATE_STATISTICS_ASYNC OFF 
GO

ALTER DATABASE [api] SET DATE_CORRELATION_OPTIMIZATION OFF 
GO

ALTER DATABASE [api] SET TRUSTWORTHY OFF 
GO

ALTER DATABASE [api] SET ALLOW_SNAPSHOT_ISOLATION OFF 
GO

ALTER DATABASE [api] SET PARAMETERIZATION SIMPLE 
GO

ALTER DATABASE [api] SET READ_COMMITTED_SNAPSHOT OFF 
GO

ALTER DATABASE [api] SET HONOR_BROKER_PRIORITY OFF 
GO

ALTER DATABASE [api] SET  READ_WRITE 
GO

ALTER DATABASE [api] SET RECOVERY FULL 
GO

ALTER DATABASE [api] SET  MULTI_USER 
GO

ALTER DATABASE [api] SET PAGE_VERIFY CHECKSUM  
GO

ALTER DATABASE [api] SET DB_CHAINING OFF 
GO

USE [api];
			CREATE TABLE [dbo].[users](
				[user_id] [bigint] IDENTITY(1,1) NOT NULL,
				[username] [varchar](50) NOT NULL,
				[user_org_id] [bigint] NOT NULL,
				[user_created_time] [bigint] NOT NULL,
				[user_ext_mail] [nvarchar](max) NULL,
				[user_ep] [nvarchar](max) NOT NULL,
			PRIMARY KEY CLUSTERED
			(
				[user_id] ASC
			)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
			) ON [PRIMARY]
				
			ALTER TABLE [dbo].[users] ADD CONSTRAINT [unique_user_org_id] UNIQUE NONCLUSTERED
			(
				[user_org_id]
			)

		
		
			CREATE TABLE [dbo].[application_request](
				[id] [int] IDENTITY(1,1) NOT NULL,
				[name] [varchar](100) NULL,
				[requestor] [bigint] NOT NULL,
				[url] [varchar](1000) NULL,
				[description] [varchar](4000) NULL,
				[poc_name] [varchar](500) NULL,
				[poc_email] [varchar](100) NULL,
				[poc_phone] [varchar](20) NULL,
				[requested_date] [bigint] NULL,
				[approved_date] [bigint] NULL,
				[justification] [varchar](4000) NULL,
				[denial_reason] [varchar](4000) NULL,
				[denied] [tinyint] NULL,
			PRIMARY KEY CLUSTERED 
			(
				[id] ASC
			)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
			) ON [PRIMARY]
				
			ALTER TABLE [dbo].[application_request]  WITH CHECK ADD FOREIGN KEY([requestor])
			REFERENCES [dbo].[users] ([user_id])

			CREATE TABLE [dbo].[application](
				[id] [int] IDENTITY(1,1) NOT NULL,
				[name] [varchar](100) NULL,
				[public_key] [varchar](100) NULL,
				[private_key] [varchar](100) NULL,
				[url] [varchar](1000) NULL,
				[description] [varchar](4000) NULL,
				[poc_name] [varchar](500) NULL,
				[poc_email] [varchar](100) NULL,
				[poc_phone] [varchar](20) NULL,
				[app_request_id] [int] NULL,
			PRIMARY KEY CLUSTERED 
			(
				[id] ASC
			)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
			) ON [PRIMARY]
			
			ALTER TABLE [dbo].[application]  WITH CHECK ADD FOREIGN KEY([app_request_id])
			REFERENCES [dbo].[application_request] ([id])

			CREATE TABLE [dbo].[request](
				[id] [int] IDENTITY(1,1) NOT NULL,
				[application_id] [int] NULL,
				[call] [varchar](max) NULL,
				[call_date] [bigint] NULL,
				[response_code] [int] NULL,
				[response] [varchar](1000) NULL,
			PRIMARY KEY CLUSTERED 
			(
				[id] ASC
			)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
			) ON [PRIMARY]
			
			ALTER TABLE [dbo].[request]  WITH CHECK ADD FOREIGN KEY([application_id])
			REFERENCES [dbo].[application] ([id])

			CREATE TABLE [dbo].[account_request](
				[id] [int] IDENTITY(1,1) NOT NULL,
				[user_org_id] [bigint] NOT NULL,
				[first_name] [nvarchar](100) NOT NULL,
				[middle_name] [nvarchar](100) NULL,
				[last_name] [nvarchar](100) NOT NULL,
				[ext_mail] [nvarchar](200) NULL,
				[title] [nvarchar](300) NULL,
				[department] [nvarchar](300) NULL,
				[organization] [nvarchar](300) NULL,
				[location] [nvarchar](500) NULL,
				[telephone] [nvarchar](100) NULL,
				[mobile] [nvarchar](100) NULL,
				[request_date] [bigint] NOT NULL,
				[approved_date] [bigint] NULL,
				[justification] [varchar](4000) NULL,
				[denied] [tinyint] NOT NULL,
			PRIMARY KEY CLUSTERED 
			(
				[id] ASC
			)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
			) ON [PRIMARY]

			CREATE TABLE [dbo].[event_log](
				[id] [bigint] IDENTITY(1,1) NOT NULL,
				[target_type] [int] NOT NULL,
				[target_id] [bigint] NOT NULL,
				[actor_type] [int] NOT NULL,
				[actor_id] [bigint] NOT NULL,
				[action] [nvarchar] (MAX) NOT NULL,
				[event_date] [bigint] NOT NULL,
				[success] [tinyint] NOT NULL
			) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

			
			CREATE TABLE [dbo].[logins](
				[id] [bigint] IDENTITY(1,1) NOT NULL,
				[session_id] [nvarchar](50) NOT NULL,
				[ip_address] [nvarchar](50) NOT NULL,
				[login_time] [bigint] NOT NULL,
				[success] [tinyint] NOT NULL,
				[error_msg] [nvarchar](MAX) NOT NULL,
				[org_id] [bigint] NOT NULL
			) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

			CREATE TABLE [dbo].[mail_log](
				[id] [bigint] IDENTITY(1,1) NOT NULL,
				[time] [bigint] NOT NULL,
				[size] [bigint] NOT NULL,
				[sender] [varchar](MAX) NOT NULL,
				[recipient] [varchar](MAX) NOT NULL,
				[attachment_types] [nvarchar](MAX) NOT NULL,
				[success] [tinyint] NOT NULL,
				[inbound_outbound] [tinyint] NOT NULL,
				[mdn] [tinyint] NULL
			) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
		

			CREATE TABLE [dbo].[ticket_category](
				[id] [bigint] IDENTITY(1,1) NOT NULL,
				[category] [varchar](200) NULL,
			PRIMARY KEY CLUSTERED
			(
				[id] ASC
			)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
			) ON [PRIMARY]


		INSERT INTO ticket_category (category) VALUES ('Contact');
		

			CREATE TABLE [dbo].[tickets](
				[id] [bigint] IDENTITY(1,1) NOT NULL,
				[parent_id] [bigint] NULL,
				[user_id] [bigint] NULL,
				[message] [varchar](4000) NULL,
				[open_date] [bigint] NULL,
				[close_date] [bigint] NULL,
				[category_id] [bigint] NULL,
			PRIMARY KEY CLUSTERED
			(
				[id] ASC
			)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
			) ON [PRIMARY]
		
			ALTER TABLE [dbo].[tickets]  WITH CHECK ADD FOREIGN KEY([user_id])
			REFERENCES [dbo].[users] ([user_id])
				
			ALTER TABLE [dbo].[tickets]  WITH CHECK ADD FOREIGN KEY([parent_id])
			REFERENCES [dbo].[tickets] ([id])
				
			ALTER TABLE [dbo].[tickets]  WITH CHECK ADD FOREIGN KEY([category_id])
			REFERENCES [dbo].[ticket_category] ([id])